package mcfall.raytracer;

import mcfall.math.Matrix;
import mcfall.math.Ray;
import mcfall.raytracer.objects.HitRecord;

public interface ThreeDimensionalObject {
	/**
	 * Transforms this object according to the transformation specified by <i>transform</i>, by applying this 
	 * transform <b>after</b> any previous transformations which have been applied to the object
	 * @param transform a square transformation matrix which modifies the current transformation
	 */
	public void transform (Matrix transform);
	
	/**
	 * Determines the time at which the ray <i>ray</i> hits this object
	 * @param ray
	 * @return a List of hit records, each of which contains:
	 * <ul>
	 * 	<li>a double hit time value, which can either be positive (in which case the ray 
	 * truly hits the object) or negative (in which case the object is "behind" the ray's origin
	 * and doesn't actually get hit by the ray)
	 * 	</li>
	 *	<li>the outward pointing normal vector on the object where the hit occurred.</li>
	 * </ul>
	 */
	public java.util.List<HitRecord> hitTime (Ray ray);
	
	/**
	 * Retrieves a name associated with this object, generally used for debugging purposes
	 * @return the string assigned to this object when it was constructed
	 */
	public String getName();
	
	/**
	 * Returns a Material object that describes the reflection properties of this object
	 * @return
	 */
	public Material getMaterial ();
	
	/**
	 * Sets the material describing the reflection properties of this object
	 * @param material
	 */
	public void setMaterial (Material material);

	/**
	 * Returns the current transformation of this object
	 * @return a matrix representing the current transformation being applied
	 * to this object
	 */
	public Matrix getTransform();
	
	/**
	 * Sets the reflectivity value of this object, ranging from 0
	 * (not reflective) to 1 (completely reflective)
	 * 
	 */
	public void setReflectionCoefficient (double value);
	
	/*  Returns the reflectivity value of this object, ranging from 0
	 * (not reflective) to 1 (completely reflective)
	 */
	public double getReflectionCoefficient ();
	/*
	 * Returns the refraction ratio between space and the object
	 */
	public double getRefractionIndex ();
	public void setRefractionIndex(double refractionPercent);
	public double getTransparency();
	public void setTransparency(double transparency);
}
